/* File searchStr.java.
   Developed for Problem Solving with Java, Koffman & Wolz.
   Appears in Fig. 11.16.

   Searches for target in string s.
   Precondition: target & string s are defined.
   Postcondition: Returns position of its last occurrence
                  if target is located in
                  string s; otherwise, returns -1.
*/

public static int searchStr(String s, char target) {
	int posLast = s.length() - 1; // index of last character

	if (posLast == -1)
		return -1;           // Empty string
	else if (s.charAt(posLast) == target)
		return posLast;      // Found - return location.
	else  // Search rest of string.
		return searchStr(s.substring(0, posLast), target);
}

