/*	File: TowersOfHanoi.java
	Developed for Problem Solving with Java, Koffman & Wolz
	Appears in Fig. 11.24
*/

import simpleIO.*;

public class TowersOfHanoi extends SimpleGUI {

	// Data fields
	private int numDisks;        // input - number of disks
	private char sourcePeg;      // input - starting peg
	private char destinationPeg; // input - ending peg
	private char sparePeg;       // input - other peg

	// Methods
	public void readTowerData() {
	   numDisks = getInt("How many disks", 1, 8);

	   // Get 3 different pegs.
	   sourcePeg = getChar("Enter the source peg",'A','C');
	   destinationPeg = 
	               getChar("Enter destination",'A','C');
	   sparePeg = 
	               getChar("Enter the spare peg",'A','C');
	}


	/* Moves n disks from fromPeg to toPeg
	   using auxPeg as an intermediary.
	   Precondition : fromPeg, toPeg, auxPeg, and
					n are defined.
	   Postcondition: Displays a list of move instructions
					that transfer the disks.
	*/
	public void tower(char fromPeg,
		             char toPeg,
			        char auxPeg,
			        int n) {
		if (n == 1)
			displayResult("Move disk 1 from peg " + 
                               fromPeg + " to peg " + toPeg);
		else { // recursive step
			tower (fromPeg, auxPeg, toPeg, n-1);
			displayResult("Move disk " + n + 
                " from peg " + fromPeg + " to peg " + toPeg);
			tower(auxPeg, toPeg, fromPeg, n-1);
		}
	}


	public void showTower() {
	   readTowerData();

	   tower(sourcePeg, destinationPeg, sparePeg, numDisks);
	}

} // class TowersOfHanoi

