import java.awt.*;
import java.applet.Applet;
import java.awt.event.*;

public class BlobApplet extends Applet implements ActionListener {

	private SmartButton [][] buttons;   // array of smart buttons
	private Label result = new Label(); // label for result

	public void init() {
        Panel Map  = new Panel();

        // Define bitMap array
		int[][] bitMap =  { {1,1,0,0,0},
							{0,1,1,0,0},
							{0,0,1,0,1},
							{0,0,0,0,1},
							{1,0,0,0,1},
							{0,1,0,1,1}
						  };

		// Create an array of the proper size.
		buttons = new SmartButton[bitMap.length][bitMap[0].length];

		// Create the grid.
		Map.setLayout(new GridLayout(buttons.length, buttons[0].length));

		// Traverse the array of buttons. Create each button, add it to
		//   the panel, and register it.
		for (int r = 0; r < buttons.length; r++)
			for (int c = 0; c < buttons[r].length; c++) {
				Color col;
				if (bitMap[r][c] == 1)
					col = Color.green;
				else
					col = Color.blue;
				// Make a new smart button
				buttons[r][c] = new SmartButton(r + "," + c, col, r, c);

				// Add it to the panel and register the applet as the listener.
				Map.add(buttons[r][c]);
				buttons[r][c].addActionListener(this);
			}

	   	add(Map);      // Add the grid to the panel
	   	add(result);   // Add the label to the panel
	}


	public void actionPerformed(ActionEvent e) {
		SmartButton b = (SmartButton) e.getSource();

		// Find the size of the blob.
		int count = findBlob(b.getRow(), b.getColumn());

		// Reset the colors.
		recolorMap();

		// display the result.
		result.setText("Button " + b + ", cells in blob:  " + count);
		result.invalidate();
		validate();
	}

	// For each button reset the current color field to the background color.
	private void recolorMap() {
		for (int r = 0; r < buttons.length; r++)
			for (int c = 0; c < buttons[r].length; c++)
				buttons[r][c].setStoredColor(buttons[r][c].getBackground());
	}

	// Find the size of the blob.
    private int findBlob(int r, int c) {
	  	if ( r < 0 || c < 0 || r >= buttons.length || c >= buttons[0].length)
	  		return 0;                     // cell is not in the array
		else if (buttons[r][c].getStoredColor() == Color.blue)
		    return 0;                     // cell is empty
		else {
			buttons[r][c].setStoredColor(Color.blue);  // Mark cell empty.
			// Count it and its neighbors that are filled in the blob.
			return 1 + findBlob(r-1,c-1) + findBlob(r,c-1) + findBlob(r+1,c-1)
					 + findBlob(r-1,c  )                   + findBlob(r+1,c  )
					 + findBlob(r-1,c+1) + findBlob(r,c+1) + findBlob(r+1,c+1);
		}
	}

} // class BlobApplet

