import java.awt.*;

public class SmartButton extends Button {
    // Data fields
	private Color curColor;
	private int row;
	private int column;

    // Methods
	// constructor
	public SmartButton(String s, Color col, int r, int c) {
		super(s);          // Call button constructor - define label field
		curColor = col;
		row = r;
		column = c;
		setBackground(col);  // Define background color.
	}

	// accessors
	public int getRow() {return row;}
	public int getColumn() {return column;}
	public Color getStoredColor() {return curColor;}

	// modifier
	public void setStoredColor(Color col) {curColor = col;}

	// toString
	public String toString() {
		String col;
		if (curColor == Color.green)
		   col = "green";
		else
		   col = "blue";
		return row + "," + column + " (" + col + ")";
	}
} // class SmartButton
