/*	File: SmartButton.java
	Developed for Problem Solving with Java, Koffman & Wolz
	Appears in Fig. 11.28
*/

import java.awt.*;

public class SmartButton extends Button {
    // Data fields
	private Color curColor;
	private Point pos;
	

    // Methods
	// constructor
	public SmartButton(String s, Color c, int y, int x) {
		super(s);          // Call button constructor - 
                             //    define label field
		curColor = c;
		pos = new Point (y,x);
		setBackground(c);  // Define background color.
	}

	// accessors
	public int getX() {return pos.x;}
	public int getY() {return pos.y;}
	public Color getStoredColor() {return curColor;}

	// modifier
	public void setStoredColor(Color c) {curColor = c;}

	// toString
	public String toString() {
		String col;
		if (curColor == Color.green)
		   col = "green";
		else
		   col = "blue";
		return pos.x + "," + pos.y + " (" + col + ")";
	}
} // class SmartButton
