/*  File: LinkList.java
    Developed for Problem Solving with Java, Koffman & Wolz
    Appears in Figure 12.10
*/

package linkList;

import simpleIO.*;
import linkList.*;

public class LinkList extends SimpleGUI {
	
	private ListNode head;         // reference to
	                               //   first list node

	public void buildTestList() {
		// Build a list with nodes p and q.
		ListNode p = new ListNode("the");
		ListNode q = new ListNode("hat");
		p.link = q;

		// Insert a new node between nodes p and q.
		p.link = new ListNode("top", q);
		// Insert a new node at head of list.
		head = new ListNode("in", p);

		//Append a new node to the end of the list.
		q.link = new ListNode("box");
		head.link = p.link; // Bypass node p.
		p.link = null;      // Disconnect p from the list.
	}	


	/*
	   Displays the linked list to which it is applied.
	   precondition : The last list node has a null link.
	   postcondition: The data fields of each list node
	                  are displayed.
	*/
	public void traverse(ListNode next) {
		if (next != null) {
			displayResult(next.info);
			traverse(next.link);
		}
	}


	public void showListTraverse() {
		buildTestList();

		traverse(head);
	}
} // class LinkList


