/*  File: StackList.java
    Developed for Problem Solving with Java, Koffman & Wolz
    Appears in Figure 12.12
*/

package stackList;

import stackList.*;

public class StackList {
   // Data fields
   private StackNode top;         // reference to 
                                  //   top of stack

   // Methods
   /* push - pushes an item onto a stack
      precondition : item is defined
      postcondition: item is at the top of the stack
   */
   public void push(Object item) {
      //Allocate a new node, store item in it, and
      //  link it to old top of stack.
      top = new StackNode(item, top);
   }


   /* pop - pops an item from a stack
      precondition : stack is defined and is not empty
      postcondition: returns item at top of stack and
                     removes it from the stack. Old second
                     stack element is at top of stack.
   */
   public Object pop() {
       StackNode oldTop = top; // Reference to top of stack

       Object item = peek();   // Retrieve item at top

       //Remove old top of stack
       top = top.link;     // Link top to second element
       oldTop.link = null; // Disconnect old top of stack

       return item;        // Return data at old top
   }


   /* peek - retrieves an item from a stack
    * precondition : stack is defined and is not empty
    * postcondition: returns item at top of stack without
    *                removing it.
    */
   public Object peek() {
       if (isEmpty())
          throw new NullPointerException();
       return top.info;      //return top item
   }


   /* isEmpty - tests whether a stack is empty
    * precondition : none
    * postcondition: returns true if stack is empty; 
    *                otherwise, returns false.
    */
    public boolean isEmpty() {
        return (top == null);
    }
} // class StackList

