/*  File: StringsInReverse.java
    Developed for Problem Solving with Java, Koffman & Wolz
    Appears in Figure 12.13
*/

package stackList;

import simpleIO.*;
import stackList.*;

public class StringsInReverse extends SimpleGUI {

	// Methods	
	// Reads a group of strings & pushes them onto a stack.
	public void readStringStack(StackList s) {
		String next = 
                        getString("Enter a string or ***:");
		while (!next.equals("***")) {
			s.push(next);
			next =
		              getString("Enter a string or ***:");
		}
	}

	// Pops strings off the stack and displays them.
	public void showStringStack() {
		StackList s = new StackList();  // Create a stack.
		
		readStringStack(s);  // Read data into stack.

		// Pop each string and display it.
		while (!s.isEmpty()) {
			String next = (String) s.pop();
			displayResult(next);
		}
	}
} // class StringsInReverse

