/*  File: StackVector.java
    Developed for Problem Solving with Java, Koffman & Wolz
    Appears in Figure 12.17
*/

import java.util.*;

public class StackVector extends Vector {
  /* push - pushes an item onto a stack
     precondition : item is defined
     postcondition: item is at the top of the stack
  */
  public void push(Object item) {
    addElement(item);
  }


 /* pop - pops an item from a stack
  * precondition : stack is defined and is not empty
  * postcondition: returns item at top of stack and
  *                removes it from the stack. Old second
  *                stack element is at top of stack.
  */
  public Object pop() {
     Object item;

     item = peek();                // Retrieve item at top
     removeElementAt(size() - 1);  // Remove top element
     return item;
  }


 /* peek - retrieves an item from a stack
  * precondition : stack is defined and is not empty
  * postcondition: returns item at top of stack without
  *                removing it.
  */
  public Object peek() {
    if (isEmpty())
	    throw new NullPointerException();
    return elementAt(size() - 1);
  }


  /* isEmpty - tests whether a stack is empty
   * precondition : none
   * postcondition: returns true if stack is empty; 
   *                otherwise, returns false.
   */
//  public boolean isEmpty() {
//    return (size() == 0);
//  }
} // class StackVector

