/*  File: Queue.java
    Developed for Problem Solving with Java, Koffman & Wolz
    Appears in Figure 12.20
*/

package queue;

public class Queue {
	// Data fields
	private QueueNode front;  // reference to front of queue
	private QueueNode rear;   // reference to rear of queue
	private int size;         // size of queue

	// Methods
	/* Inserts item in a queue.
	   precondition : none
	   postcondition: Inserts item in a new node and resets
	      rear to reference the new node. If the queue has
	      1 element, front references the new node also.
	*/
	public void insert(Object item) {

		if (isEmpty()) { //empty queue
			// Link rear and front to only node.
			rear = new QueueNode(item);
			front = rear;
		} else { //extend a non-empty queue
			rear.link = new QueueNode(item);
			rear = rear.link;  // Move rear to new node.
		}

		size++;                 //Increment queue size.
	}


	/* Returns the element at the front of the queue
	   precondition : The queue has been created.
	   postcondition: If the queue is not empty, returns its
	   first element & front references new first element.
	*/
	public Object remove() {
		QueueNode oldFront = front; // reference to front

		Object item = peek();   // Retrieve first item.

		// Remove first element
		front = front.link;    // Delete first node.
		oldFront.link = null;  // Disconnect it from queue.
		size--;                // Decrement queue size.

		return item;
	}


	/* Returns the element at the front of the queue
	   precondition : The queue has been created.
	   postcondition: If the queue is not empty, returns its
	      first element.
	*/
	public Object peek() {
		if (isEmpty())
			throw new NullPointerException();
		return front.info;
	}


	/* Tests for an empty queue.
	   precondition : none
	   postcondition: Returns true if queue is empty;
	                  otherwise, returns False.
	*/
	public boolean isEmpty() {
	   return (size == 0);
	}


	public int getSize() {
		return size;
	}
} // class Queue

