/*  File: SearchTree.java
    Developed for Problem Solving with Java, Koffman & Wolz
    Appears in Figure 12.26
*/

package searchTree;

import simpleIO.*;
import searchTree.*;

public class SearchTree extends SimpleGUI {
	// Data fields
	private TreeNode root;

	//Methods
	/* Inserts item into a binary search tree.
	   precondition : none
	   postcondition: Returns true if the insertion is
	                  performed. Returns false if there
	                  is a node with the same key as item.
	*/
	public boolean insert(Object item) {
		if (isEmpty()) { // empty search tree
		   root = new TreeNode(item); // Insert item in root.
		   return true;
		} else  // Find insertion point and insert item.
		   return root.insertNode(item);
	}


	public boolean isEmpty() {
		return (root == null);
	}

	// Insert methods search and display (Fig. 12.28) here.

	/*
	   Searches for the tree item that matches target
	   precondition : none.
	   postcondition: Returns true if target's key is found;
	                  otherwise, returns false.
	*/
	public boolean search(Object target) {
		return search(root, target);
	}

	private boolean search(TreeNode root, Object target) {
		if (isEmpty())
			return false;           // Tree is empty.
		else if 
		(target.toString().compareTo(root.info.toString())
		   == 0)
			return true;          // Target is found.
		else if
		(target.toString().compareTo(root.info.toString())
		   < 0)
			// target key < root key - check left subtree
			if (root.left == null)
				return false;  // Left subtree empty.
			else  // Search left.
				return search(root.left, target);
		// target key > root key - check right subtree
		else if (root.right == null)
			return false;     // Right subtree empty.
		else  // Search right.
			return search(root.right, target);
	}


	/* Displays a binary search tree in key order.
	   precondition : none
	   postcondition: Displays each node in key order.
	*/
	public void display() {
		display(root);
	}

	private void display(TreeNode root) {
		if (!isEmpty()) {
			// Display left subtree.
			if (root.left != null)
				display(root.left);

			// Display root key.
			displayResult((root.info).toString());

			// Display right subtree.
			if (root.right != null)
				display(root.right);
		}
	}

} // class SearchTree

