%SETDAT Reset data and feature labels of dataset
%
%   A = SETDAT(A,DATA,W)
%
% INPUT
%    A      Dataset
%    DATA   Dataset or double  
%    W      Mapping  (optional)
%
% OUTPUT
%    A      Dataset 
%
% DESCRIPTION
% The data in the dataset A is replaced by DATA (dataset or double). The
% number of objects in A and DATA should be equal. Optionally, A is given
% the feature labels and the output size as defined by the the mapping W.
% This call is identical to:
%    A = SETDATA(A,DATA);
%    A = SET(A,'featlab',GETLABELS(W),'featsize',GETSIZE_OUT(W));
%
% SEE ALSO
% DATASET, SETDATA

% Copyright: R.P.W. Duin, duin@ph.tn.tudelft.nl
% Faculty of Applied Sciences, Delft University of Technology
% P.O. Box 5046, 2600 GA Delft, The Netherlands

% $Id: setdat.m,v 1.7 2004/03/19 09:19:43 duin Exp $

function a = setdat(a,b,w)
	prtrace(mfilename);

	if ~isdataset(a)
		a = dataset(a);
	end
		
	a = setdata(a,b);

	if (nargin > 2)
		if (~isa(w,'mapping'))
			error('Third parameter should be mapping')
		end
		% Special case: 2 classes, p(class2) = 1-p(class1).
		if (size(a,2) == 1) & (size(w,2) == 2)
			a = [a 1-a];
		end
		% Add attributes of W to A.
		a = set(a,'featlab',getlabels(w),'featsize',getsize_out(w));
	end
		
	return;
