import java.util.Scanner;

/** 
 * This program will demonstrate expressions and variables 
 * by using a simple version of the investment problem from last time
 *
 * Suppose that you put $10000 into a bank account that gives you
 * 5% interest per year. Calculate the interest and the balance 
 * at the end of year 1 and year 2.
 * 
 * @author Aynur Dayanik
 * @version Week 2
 */


public class BalanceCalculator 
{
   public static void main( String[] args ) {
      // Constants
      final double INTEREST_RATE = 0.05;
      final double INITIAL_BALANCE = 10000;
    
      // Variables
      double balance;  // the balance in the bank account
      double interest;
      int year;
    
        
      // Calculate the interest and the balance at the end of year 1
      // Report these values
      System.out.println( "Interest in year 1: " + 10000 * 0.05 );
      System.out.println( "Balance after year 1: " + 
                         (10000 + 10000 * 0.05) );
      
      // Calculate the interest and the balance at the end of year 2
      // Report these values
      System.out.println( "Interest in year 2: " +
                         (10000 + 10000 * 0.05) * 0.05 );
      System.out.println( "Balance after year 2: " + 
                         ((10000 + 10000 * 0.05) + 
                          (10000 + 10000 * 0.05) * 0.05) );
    
      // We repeated the calculations above redundantly.
      // Instead, let us use variables to remember the calculations that we do.
      
      // Set balance to 10000
      balance = INITIAL_BALANCE;
      // Set year to 1
      year = 1;
      
      // Calculate the interest and the balance at the end of year 1
      // Report these values
      interest = balance * INTEREST_RATE;
      System.out.println( "Interest in year " + year + ": " + interest );
      balance = balance + interest;
      System.out.println( "Balance after year " + year + ": " + balance );
    
      // Calculate the interest and the balance at the end of year 2
      // Report these values
      year = year + 1;
      interest = balance * INTEREST_RATE;
      System.out.println( "Interest in year " + year + ": " + interest );
      balance = balance + interest;
      System.out.println( "Balance after year " + year + ": " + balance );
        
      
//        
//        // Just to show we can do the same calculations using a for loop for many years.
//        // We will learn for loop later.
//        for (  year = 1; year < 10; year = year + 1 )
//        {
//            interest = balance * INTEREST_RATE ;
//            System.out.println( "Interest in year " + year + ": " + interest );
//            balance = balance + interest;
//            System.out.println( "Balance after year " + year + ": " + balance );
//        }
        
    }
}
