import java.util.Scanner;

/**
 * Assigns a letter grade for a numeric score entered by the user 
 * according to the following rules. 
 * 
 *    90-100   A
 *    80-89    B
 *    70-79    C
 *    60-69    D
 *     0-59    F
 * 
 * It does input validation: input numeric grade must be an integer between 
 * 0 and 100.
 * 
 * @author Aynur
 * @version Week 3
 */ 
public class LetterGradeWithValidation
{
   public static void main( String[] args)
   {
      Scanner scan = new Scanner( System.in);
      
      // constants
      
      // variables
      int score;
      char letterGrade;
      boolean validInput;  
      
      // program code
      System.out.println( "Start...");
      
      System.out.print( "Enter a numeric grade between 0 and 100: " );
      
      // Warn the user if the input is not an integer
      if ( !scan.hasNextInt() ) 
      {
         System.out.println( "Input must be integer." );
      }
      else 
      {
         score = scan.nextInt();
         
         validInput = score >= 0 && score <= 100;
         
         // Warn the user if the grade is invalid
         if ( !validInput ) 
         {
            System.out.println( score + " is an invalid numeric grade." );
         }
         else 
         {
            // determine the letter grade
            if ( score > 90 )
            {
               letterGrade = 'A';
            }
            else if ( score > 80 ) 
            {
               letterGrade = 'B';
            }
            else if ( score > 70 )             
            {
               letterGrade = 'C';
            }
            else if ( score > 60 ) 
            {
               letterGrade = 'D';
            }
            else
            {
               letterGrade = 'F';  
            }
            
            System.out.println( "Letter grade is " + letterGrade + 
                               " for " + score ); 
         }
      }
      
      System.out.println( "End.");
   }
   
}
