/**
 * Card - a single playing card
 * @author
 * @version 1.00 2012/2/15
 */
public class Card
{
	final String[] SUITS = { "Hearts", "Diamonds", "Spades", "Clubs"};
	final String[] FACES = { "A", "2", "3", "4", "5",
							 "6", "7", "8", "9", "10",
							 "J", "Q", "K"};
	// properties
	int		cardNo;

	// constructors
	public Card( int faceValue, int	suit )
	{
		cardNo = faceValue + suit * 13;
	}

	public Card( int cardNumber)
	{
		cardNo = cardNumber;
	}

	public int getFaceValue()
	{
		return cardNo % 13;
	}

	public int getSuit()
	{
		return cardNo / 13;
	}

	public String toString()
	{
		return FACES[ getFaceValue() ] + " of " + SUITS[ getSuit() ];
	}
}