import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import cs102.Hangman;
import cs102.SimpleJFrame;

// HangmanUI - uses HangmanModel class (with support for updating views)
//				 with a view and appropriate controllers.
//
// David, 2012/4/8

public class HangmanUI extends JPanel
{
	// PROPERTIES
	HangmanModel		hangmanModel;
	IHangmanView		view;

	JButton				newGameButton;

	LetterButtonControls			uiLetterControls;
	HangmanLetterButtonsController	uiLettersController;

	// CONSTRUCTORS
	public HangmanUI()
	{
		this( new HangmanModel( new HangmanSetup()), new GallowsHangmanView() );
	}

	public HangmanUI( HangmanModel model, IHangmanView view )	// boolean displayGallows)
	{
		// get the model
		hangmanModel = model;

		// get the view & attach to model
		this.view = view;
		hangmanModel.addView( view);

		// create letter buttons GUI controller
		HangmanLetterButtonsController uiLettersController = new HangmanLetterButtonsController( hangmanModel);
		uiLetterControls = new LetterButtonControls( hangmanModel.getAllLetters() );
		uiLetterControls.addActionListener( uiLettersController);

		// add view & controls to the UI
		setLayout( new BorderLayout() );

		add( uiLetterControls, BorderLayout.NORTH);
		add( (JComponent) view, BorderLayout.CENTER );

		newGameButton = new JButton( "NEW GAME");
		newGameButton.addActionListener(
			new ActionListener() 							// anon inner class for listener!
			{
				public void actionPerformed( ActionEvent e)
				{
					initNewGame();
				}
			} );

		add( newGameButton, BorderLayout.SOUTH);
	}

	// METHODS...

	// addView - adds view to model and UI
	public void addView( IHangmanView view)
	{
		hangmanModel.addView( view);
		add( (JComponent) view, BorderLayout.CENTER );
	}


	// tryThis - simply routes updates to model
	public int tryThis( char letter)
	{
		return hangmanModel.tryThis( letter);
	}

	// initNewGame - simply routes to model
	public void initNewGame()
	{
		hangmanModel.initNewGame();
	}


	// **************************************************************************************
	// uiLetterControls controller class...
	// can be a completely separate class (as an inner class there is no need for the constructor).
	// **************************************************************************************
	public class HangmanLetterButtonsController implements ActionListener
	{
		Hangman hangmanModel;

		public HangmanLetterButtonsController( Hangman hangmanModel)
		{
			this.hangmanModel = hangmanModel;
		}

		public void actionPerformed( ActionEvent e)
		{
			if ( !hangmanModel.isGameOver() )
			{
				JButton b = (JButton) e.getSource();
				char letter = b.getLabel().charAt(0);
				// hangmanModel.tryThis( letter);
				tryThis( letter);
			}
		}
	}
	// **************************************************************************************

} // end class Hangman
