import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import javax.swing.border.*;
/**
 * LetterButtonControls - keyboard for MVC demo of Hangman, but general.
 *
 * Note:	Does not disable letters already used by other controllers!
 *			Make IHangmanView and update buttons from model.
 *
 * @author David
 * @version 1.00 2012/4/8
 */
public class LetterButtonControls extends JPanel
{
	public LetterButtonControls( String letters)
	{
		setBorder( new TitledBorder("Choose a letter...") );
		setLayout( new GridLayout( 2, 13) );

		for( int i = 0; i < letters.length(); i++) {
			JButton b = new JButton( "" + letters.charAt(i) );
			b.setMargin( new Insets( 1, 2, 1, 2) );
			// b.addActionListener( this);							// add this class as listener for letter buttons
			// b.addKeyListener( this);
			add( b);
		}
	}

	public void addActionListener( ActionListener l)
	{
		Component[] buttons = getComponents();
		for ( Component b : buttons )
		{
			( (JButton) b).addActionListener( l);					// add this class as listener for letter buttons
			// b.addKeyListener( this);
		}
	}

	public void setEnabledAll( boolean state)
	{
		for ( Component c : getComponents() ) {
			((JButton) c).setEnabled( state);
		}
	}

	public void setDisabled( String letters)
	{
		for ( Component c : getComponents() ) {
			char ch = ((JButton) c).getLabel().charAt(0);
			if ( letters.indexOf(ch) >= 0)
				((JButton) c).setEnabled( false);
		}
	}
}