package maze.fun;

import java.util.ArrayList;

public class Maze 
{
	private IGrid grid;
	public void setGrid(IGrid grid) {
		this.grid = grid;
	}
	public ArrayList<Path> findPaths() {
		return traverse(grid.getStart(), new Path());
	}
    /* @param l the current location
     * @param p the path from origin up to (but excluding) location l
     * @return all paths from (including) location l to the exit
     */
	private ArrayList<Path> traverse(Location l, Path p) {
		// Create a new array list to hold all the result paths
        // Check if the location l is valid, that is:
        //   - It is in the grid
        //   - It is not a wall
        //   - It is not visited before (it is not in path)
        // Check if l is already the exit location
        // If yes
        //   Add a path that contains only location l into the result paths
        // Otherwise
        //   Append l to p (extend the path from the origin with the current location)
        //   For each direction 
        //      Call yourself recursively on the location towards that direction
        //      Add the results from the recursive call to the result paths
        //   For each path in the result paths
        //      Prepend location l to the path
        //   Remove l from p (since we are going to return back to the previous call)
        // Return 
	}
	public static void main(String[] args) {
		int[][] mdata = {{1,1,1,0,1,1,0,0,0,1,1,1,1},
	            	     {1,0,1,1,1,0,1,1,1,1,0,0,1},
		                 {0,0,0,0,1,0,1,0,1,0,1,0,0},
		                 {1,1,1,0,1,1,1,0,1,0,1,1,1},
		                 {1,0,1,0,0,0,0,1,1,1,0,0,1},
	                     {1,0,1,1,1,1,1,1,0,1,1,1,1},
	                     {1,0,1,0,0,0,0,0,0,1,1,0,0},
		                 {1,1,1,1,1,1,1,1,1,1,1,1,1}};
		IGrid grid = new Grid(mdata);
		Maze maze = new Maze();
		maze.setGrid(grid);
		ArrayList<Path> paths = maze.findPaths();
		for (Path p: paths) 
			System.out.println(p);
	}
}









