// JRobo    Basic JRobo class with rect method added
// Author:  David 4/9/99

import java.awt.*;

public class JRobo
{

    int x;          // current x, y location
    int y;
    boolean draw;   // pen up/down
    int heading;    // direction - in degrees

    Graphics robog; // keep info about where to draw

    // Constructor
    JRobo( Graphics g )
    {
        x = 200;
        y = 150;
        draw = true;
        heading = 0;
        robog = g;
    }

    // r - Turn Right
    public void r( int degrees )
    {
          heading = ( heading + degrees ) % 360;
    }

    // l - Turn Left
    public void l( int degrees )
    {
          heading = ( heading - degrees ) % 360;
    }

    // f - Move forward
    public void f( int distance )
    {
        int dx, dy;
        dx = ( int ) Math.round( distance * Math.sin( heading * 2 * 3.142 / 360 ) * 500/1000 );
        dy = ( int ) Math.round( distance * -Math.cos( heading * 2 * 3.142 / 360 ) * 500/1000 );
        if (draw)
             robog.drawLine( x, y, x + dx, y + dy );
        x = x + dx;
        y = y + dy;
    }

    // p - Change pen state
    public void p(  )
    {
        draw = ! draw;
    }

	// rect - Draw rectangle with given height and width
	// Pre: Facing north, pen down, bottom left corner.
	// Post: as pre-cond., with rectangle drawn.
	public void rect( int height, int width )
	{
		f( height );
		r( 90 );
		f( width );
		r( 90 );
		f( height );
		r( 90 );
		f( width );
		r( 90 );
	}

} // end JRobo class
