// JRobo    Basic JRobo class
// Author:  David 4/9/99

import java.awt.*;

public class JRobo
{

    int x;          // current x, y location
    int y;
    boolean draw;   // pen up/down
    int heading;    // direction - in degrees

    Graphics robog; // keep info about where to draw

    // Constructor
    JRobo( Graphics g ) {
        x = 200;
        y = 150;
        draw = true;
        heading = 0;
        robog = g;
    }

    // r - Turn Right
    public void r( int degrees )
    {
          heading = ( heading + degrees ) % 360;
    }

    // l - Turn Left
    public void l( int degrees )
    {
          heading = ( heading - degrees ) % 360;
    }

    // f - Move forward
    public void f( int distance )
    {
        int dx, dy;
        dx = ( int ) Math.round( distance * Math.sin( heading * 2 * 3.142 / 360 ) * 500/1000 );
        dy = ( int ) Math.round( distance * -Math.cos( heading * 2 * 3.142 / 360 ) * 500/1000 );
        if ( draw )
             robog.drawLine( x, y, x + dx, y + dy );
        x = x + dx;
        y = y + dy;
    }

    // p - Change pen state
    public void p(  )
    {
        draw = !draw;
    }

} // end JRobo class
