// XJRobo   Extension of XJRobo 
//          which adds rect, move & equtri methods.
// Author:  David 5/9/99
// Version: 1.0

import java.awt.*;

public class XJRobo extends JRobo
{
	public XJRobo ( Graphics g )
	{
        super( g );
    }

    // rect - Draw rectangle with given height and width
    // Pre: Facing north, pen down, bottom left corner.
    // Post: as pre-cond., with rectangle drawn.
    public void rect( int height, int width )
    {
    	f( height );
    	r( 90 );
    	f( width );
    	r( 90 );
    	f( height );
    	r( 90 );
    	f( width );
    	r( 90 );
    }
	
	// move - reposition JRobo x, +dx, +dy from current location
    public void move( int dx, int dy )
    {
        p();
        f( dy );
        r( 90 );
        f( dx );
        l( 90 );
        p();
    }
	
	// equtri - draws an equilateral triangle of specified size
	// Pre: facing north, pen down, bottom left corner
	// Post: as pre, with triangle drawn.
	public void equtri( int size)
	{
		r( 30 );
		f( size );
		r( 120 );
		f( size );
		r( 120 );
		f( size );
		r( 90 );
	}

} // end XJRobo class
