// JRobo    Example 6
//          Demonstrates ScaledJRobo class & extended type checking
//          (aRobo can hold normal or Scaled JRobo)
// Author:  David 5/9/99

import java.awt.*;
import java.applet.*;

public class JRoboTest extends Applet
{
    public void paint( Graphics g )
    {
        XJRobo aRobo = new XJRobo( g );
        aRobo.move( -400, -300 );
		house( aRobo );

        aRobo = new ScaledXJRobo( g );
		aRobo.move( -50, -300 );

		((ScaledXJRobo) aRobo).setScale( 0.25);
		house( aRobo );
		
		aRobo.move( 350, 0 ); 
		((ScaledXJRobo) aRobo).setScale( 0.51);
		house( aRobo );		

		aRobo.move( 300, 0 ); 
		((ScaledXJRobo) aRobo).setScale( 1.25);
		house( aRobo );		
    }

	
	// house - draw a simple house using rect, equtri and move.
	//         notice how it is drawn depends on type of JRobo!
	public void house( XJRobo r)
	{
		// draw walls
		r.rect( 250, 250 );
		
		// draw roof
		r.move( 0, 250 );
		r.equtri( 250 );
		r.move( 0, -250);
		
		// draw windows
		r.move( 50, 150 );
		r.rect( 50, 50 );
		r.move( 100, 0 );
		r.rect( 50, 50 );
		
		// draw door
		r.move( -50, -150 );
		r.rect( 75, 50 );
	}

} // end JRoboTest class
