// JRobo    Example 9
//          Demonstrates polymorphism!
// Author:  David 5/9/99

import java.awt.*;
import java.applet.*;
import java.util.ArrayList;

public class JRoboTest extends Applet
{

    ArrayList theTeam;     // this holds a collection of JRobos

    public void paint( Graphics g )
    {
		// create three different types of JRobo
        XJRobo aRobo = new XJRobo( g );
        aRobo.move( -200, 0);

        ScaledXJRobo robby = new ScaledXJRobo( g );
        robby.move( 80, 0);
        robby.setScale( 1.5 );

        ColouredXJRobo friendly = new ColouredXJRobo( g );
        friendly.move( 300, 0);
        
        // add each JRobo to the team
        theTeam = new ArrayList();
        theTeam.add( aRobo );
        theTeam.add( robby );
        theTeam.add( friendly );
        
        // tell each member of the team to draw a star
        // (polymorphism means the each do it their way!)
        for (int i = 0; i < theTeam.size(); i++)
        {
            // get next team member, someJRobo
			XJRobo someJRobo = (XJRobo) theTeam.get( i );
			
			// have someJRobo draw star
            someJRobo.l( 18 );
            someJRobo.f( 150 );
            for(int j = 0; j < 4; j++)
            {
            	someJRobo.l( 144 );
                someJRobo.f( 150 );
            }
        }
    }
    
} // end JRoboTest class
