//Title:       Runners Inc.
//Version:     2.0
//Copyright:   Copyright (c) 1998
//Author:      Gerald Boersma
//Modified:    Marius Ghetie
//Company:     Ensemble Systems Inc.
//Description: Add new customer controller in the Microsoft Access database.

package RunnersInc;

import RunnersInc.*;
import java.sql.*;

////
public class AddNewCustomer_Controller {

  Customer theCustomer = new Customer();

  //
  public String process( int option, String stringArray[] ) {

    String theString = "";

    switch (option) {

      case 1: // Get a new ID from the database
        theString = getNewCustomerID();
        theCustomer.setId( theString );
        break;

      case 2: // Submit

        theCustomer.setName( stringArray[0] );
        theCustomer.getAddress().setStreet( stringArray[1] );
        theCustomer.getAddress().setCity( stringArray[2] );
        theCustomer.getAddress().setState( stringArray[3] );
        theCustomer.getAddress().setZipCode( stringArray[4] );
        theCustomer.setContact( stringArray[5] );
        theCustomer.setPhone( stringArray[6] );
        theCustomer.getShippingAddress().setStreet( stringArray[7] );
        theCustomer.getShippingAddress().setCity( stringArray[8] );
        theCustomer.getShippingAddress().setState( stringArray[9] );
        theCustomer.getShippingAddress().setZipCode( stringArray[10] );

        if ( theCustomer.isValid() ) {
          theString = AddNewCustomer( theCustomer );
        }
        else {
          theString = "Customer not added. Make sure all fields are entered.";
        }
        break;

      default:
        break;
   }
   return theString;
  }

  // Get a new Customer ID
  public String getNewCustomerID() {

    int theCurrentCustomerID = 0;
    int theNewCustomerID = 0;

    String theURL = "jdbc:odbc:RunnersIncDatabase";
    Connection theConnection;
    Statement theStatement;
    ResultSet theResultSet;

    try {
      Class.forName( "sun.jdbc.odbc.JdbcOdbcDriver" );
    }
    catch ( java.lang.ClassNotFoundException theException ) {
      System.err.print( "ClassNotFoundException: " );
      System.err.println( theException.getMessage () );
    }

    try {
      theConnection = DriverManager.getConnection( theURL, "", "" );
      theStatement = theConnection.createStatement();

      theResultSet = theStatement.executeQuery ( "SELECT CustomerId FROM Customers" );

      if ( theResultSet != null ) {
        while ( theResultSet.next() ) {

          theCurrentCustomerID = theResultSet.getInt( "CustomerId" );

          if ( theNewCustomerID < theCurrentCustomerID  ) {
            theNewCustomerID = theCurrentCustomerID;
          }
        }
        theNewCustomerID = theNewCustomerID + 1;
      }
        theStatement.close();
        theConnection.close();
    }
    catch ( SQLException ex ) {
      System.err.println ( "SQLException: " + ex.getMessage () ) ;
    }

    return Integer.toString( theNewCustomerID );
  }

  // Add the new customer to the database
  public String AddNewCustomer( Customer theCustomer ) {

    String theString;

    if ( theCustomer.isValid() ) {
      String url = "jdbc:odbc:RunnersIncDatabase";

      Connection theConnection ;
      Statement theStatement ;

      try {
        Class.forName ( "sun.jdbc.odbc.JdbcOdbcDriver" );
      }
      catch ( java.lang.ClassNotFoundException theException ) {
        System.err.print ( "ClassNotFoundException: " );
        System.err.println ( theException.getMessage () );
      }

      try {
        theConnection = DriverManager.getConnection ( url, "", "" );
        theStatement = theConnection.createStatement ();
	
        String theQuery = "INSERT INTO Customers VALUES (" +
                    "'" + theCustomer.getId() + "', " +
                    "'" + theCustomer.getName() + "', " +
                    "'" + theCustomer.getAddress().getStreet() + "', " +
                    "'" + theCustomer.getAddress().getCity() + "', " +
                    "'" + theCustomer.getAddress().getState() + "', " +
                    "'" + theCustomer.getAddress().getZipCode() + "', " +
                    "'" + theCustomer.getContact() + "', " +
                    "'" + theCustomer.getPhone() + "', " +
                    "'" + theCustomer.getShippingAddress().getStreet() + "', " +
                    "'" + theCustomer.getShippingAddress().getCity() + "', " +
                    "'" + theCustomer.getShippingAddress().getState() + "', " +
                    "'" + theCustomer.getShippingAddress().getZipCode() + "', " +
                    "'New Customer')" ;

        theStatement.executeUpdate( theQuery ) ;

        theStatement.close();
        theConnection.close();

        theString = "Customer successfully added. Add another customer?";
      }
      catch ( SQLException theException ) {
        System.err.println ( "SQLException: " + theException.getMessage () ) ;
        theString = "Customer not added. There are errors.";
      }
    }
    else {
      theString = "Customer not added. Make sure all fields are entered.";
    }
    return theString;
  }
}

