//Title:        Runners Example
//Version:      2.0
//Copyright:    Copyright (c) 1998
//Author:       Gerald Boersma
//Modified:     Marius Ghetie
//Company:      Ensemble Systems Inc.
//Description:  Business object representing a customer.

package RunnersInc;

public class Customer {
  private String m_name;
  private String m_id;
  private Address m_address;
  private String m_contact;
  private String m_phone;
  private Address m_shippingAddress;

  //
  public Customer() {
    m_name = new String( "" );
    m_id = new String( "" );
    m_address = new Address();
    m_contact = new String( "" );
    m_phone = new String( "" );
    m_shippingAddress = new Address();
  }

  //
  public void setId( String id ) { m_id = new String( id ); }
  public String getId() { return m_id; }

  //
  public void setName( String name ) { m_name = new String( name ); }
  public String getName() { return m_name; }

  //
  public void setAddress( Address address ) {
    m_address = new Address( address ); }
  public Address getAddress() { return m_address; }

  //
  public void setContact( String contact ) {
    m_contact = new String( contact ); }
  public String getContact() { return m_contact; }

  //
  public void setPhone( String phone ) {
    m_phone = new String( phone ); }
  public String getPhone() { return m_phone; }

  //
  public void setShippingAddress( Address address ) {
    m_shippingAddress = new Address( address ); }
  public Address getShippingAddress() { return m_shippingAddress; }

  //
  public boolean isValid() {
    boolean rIsValid = false;

    // Check to see if the entered customer is correct.
    if( !m_id.equals("") && !m_name.equals("") && m_address.isValid() &&
        !m_contact.equals("") && m_shippingAddress.isValid() )
    {
        rIsValid = true;
    }
    return rIsValid;
  }
}
